#!/usr/bin/env python3


import os, subprocess
from pathlib import Path

# -------- EDIT THESE --------
LEAGUE      = "LALIGA" #LaLiga, MLS, EPL, NHL
CSV_PATH    = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/teams_rgb_correct.csv"
PROJECT_AEP = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/GOAL-Animation1-BreakGlass.aep"
OUT_DIR     = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/GOAL_Animation_1_192"
LOGO_DIR    = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Logos-Large"
ANIM_NAME   = "GOAL_1_3"     # or "GOAL_1_6"
COMP_NAME   = "GOAL-192"    # or whatever your comp name is
COMMON_JSX  = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/gl_common.jsxinc"
AE_APP_NAME = "Adobe After Effects 2025"
JSX_FILENAME= "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/batch_GOAL_Animation_1.jsx"
# ----------------------------


# NEW: TeamName text mode — "display" (displayName) or "abbr"
TEAMNAME_TEXT_MODE = "abbr"   # change to "abbr" to force abbreviations
# Optional stroke widths ("" to keep comp): e.g., "4"
GOAL_STROKE_WIDTH      = "0.5"      # e.g. "3"
TEAMNAME_STROKE_WIDTH  = "0.5"      # e.g. "0.5"
# ----------------------------

def main():
    jsx_batch = Path(__file__).parent / JSX_FILENAME
    for p,label in [
        (CSV_PATH,"CSV"), (PROJECT_AEP,"AEP"), (LOGO_DIR,"Logos"), (COMMON_JSX,"gl_common.jsxinc"), (jsx_batch,"JSX script")
    ]:
        if not Path(p).exists():
            print(f"❌ {label} not found: {p}")
            return

    Path(OUT_DIR).mkdir(parents=True, exist_ok=True)

    env = os.environ.copy()
    env.update({
        "AE_COMMON_JSX": COMMON_JSX,
        "AE_PROJECT": PROJECT_AEP,
        "AE_CSV": CSV_PATH,
        "AE_COMP": COMP_NAME,
        "AE_LEAGUE": LEAGUE,
        "AE_LOGO_DIR": LOGO_DIR,
        "AE_LOGO_PATH_TEMPLATE": "{league}/{abbr}",
        "AE_LOGO_EXTS": "png,jpg,jpeg,svg,ai,psd",
        "AE_OUTDIR": OUT_DIR,
        "AE_PATH_TEMPLATE": "{league}",
        "AE_ANIM": ANIM_NAME,
        "AE_RS_TEMPLATE": "Best Settings",
        "AE_OM_TEMPLATE": "PNG Sequence",
        "AE_PURGE_BEFORE_RENDER": "1",
        "AE_NO_RENDER": "0",
        "AE_QUIT": "1",
        # Layer mapping
        "AE_LAYER_GOAL_TEXT": "GOAL!",
        "AE_LAYER_TD_PRE": "TD PreComp",
        "AE_SOLID_LAYER": "Solid",
        "AE_TEAMNAME_LAYER": "TeamName",
        "AE_LAYER_LOGO_PRECOMP": "LogoPreComp",
        "AE_SUBLAYER_LOGO_IN_PRECOMP": "Logo",
        "AE_LAYER_LOGO": "Logo",
        # NEW: control TeamName text content
        "AE_TEAMNAME_TEXT_MODE": TEAMNAME_TEXT_MODE,
        # Optional widths
        "AE_GOAL_STROKE_WIDTH": GOAL_STROKE_WIDTH,
        "AE_TEAMNAME_STROKE_WIDTH": TEAMNAME_STROKE_WIDTH,
    })

    cmd = ["osascript", "-e", f'tell application "{AE_APP_NAME}" to DoScriptFile "{jsx_batch}"']
    print("🚀 Launching After Effects…")
    subprocess.run(cmd, env=env, check=False)

if __name__ == "__main__":
    main()
